function xbtCompare(usb, mk9, navy)

% Function to plot XBT test canister results

if nargin < 3
   navy = [];
end

if nargin < 2
   mk9 = [];
end

% Read USB file

path = 'c:/data/fr0204';
nc = netcdf([path, '/xbt/usb/', usb, '.nc']);
%r = nc{'rawTemperature'}(:);
%r = -13.2 + 1.000168 * r;
%Tusb = xbtTemp(r);
%Dusb = xbtDepth(r);
Dusb = nc{'depth'}(:);
Tusb = nc{'temperature'}(:);
close(nc);
figure(1);
plot(Tusb, Dusb);
set(gca, 'YDir', 'reverse');
title([' USB:', usb]);
xlabel('Temperature (C)');
ylabel('Depth (m)');

% Read MK9 file

if ~isempty(mk9)
   nc = netcdf([path, '/xbt/mk9/', mk9, '.nc']);
   Dmk9 = nc{'depth'}(:);
   Tmk9 = nc{'temperature'}(:);
   close(nc);
   figure(2);
   plot(Tmk9, Dmk9);
   set(gca, 'YDir', 'reverse');
   title([' Mk9:', mk9]);
   xlabel('Temperature (C)');
   ylabel('Depth (m)');
end

% Read Navy file

if ~isempty(navy)
   d = load([path, '/xbt/navy/', navy, '.edf'], '-ascii');
   Dnav = d(:, 1);
   Tnav = d(:, 2);
   figure(3);
   plot(Tnav, Dnav);
   set(gca, 'YDir', 'reverse');
   title([' Navy:', mk9]);
   xlabel('Temperature (C)');
   ylabel('Depth (m)');
end
