function xbtRead(index, ctd, usb, mk9, navy)

if nargin < 5
   navy = [];
end

if nargin < 4
   mk9 = [];
end

if nargin < 3
   usb = [];
end

% Function to add XBT drops and CTD data to array for entire voyage

load('c:/data/fr0204/xbt/voyage');

% Read CTD file

path = 'c:/data/fr0204';
nc = netcdf([path, '/avg/', ctd, 'Avg.nc']);
Pctd = nc{'pressure'}(:);
[x, i] = max(Pctd);
Pctd = Pctd(1:i);
Tctd = nc{'temperature'}(1:i);
lat(index) = nc{'latitude'}(1);
lon(index) = nc{'longitude'}(1);
close(nc);
Dctd = sw_dpth(Pctd, lat(index));
t1 = interp1q(Dctd, Tctd, d);
t(1:length(t1), 1, index) = t1;

% Read USB file

if ~isempty(usb)
    nc = netcdf([path, '/xbt/usb/', usb, '.nc']);
    Dusb = nc{'depth'}(:);
    Tusb = nc{'temperature'}(:);
    close(nc);
    t1 = interp1q(Dusb, Tusb, d);
    t(1:length(t1), 2, index) = t1;
end

% Read MK9 file

if ~isempty(mk9)
    nc = netcdf([path, '/xbt/mk9/', mk9, '.nc']);
    Dmk9 = nc{'depth'}(:);
    Tmk9 = nc{'temperature'}(:);
    close(nc);
    t1 = interp1q(Dmk9, Tmk9, d);
    t(1:length(t1), 3, index) = t1;
end

% Read Navy file

if ~isempty(navy)
    data = load([path, '/xbt/navy/', navy, '.edf'], '-ascii');
    Dnav = data(:, 1);
    Tnav = data(:, 2);
    t1 = interp1q(Dnav, Tnav, d);
    t(1:length(t1), 4, index) = t1;
end

save('c:/data/fr0204/xbt/voyage', 'lat', 'lon', 'd', 't');
