function a = xbtDepthFit(t, d)

% Function to linearly rescale the depth of each XBT drop so that it matches the CTD.
%
% Input parameter T is the temperature returned by xbtRead.
% Returns scaling coefficients.

[nDepth, nXBT, nDrop] = size(t);
a = ones(2, nXBT-1, nDrop) * NaN;
for i = 1:nDrop
    for j = 2:nXBT
        k = find(~isnan(t(:, j, i)));
        if ~isempty(k)
            a(:, j-1, i) = ...
                fminsearch('tempDiff', [0, 1], [], t(:, 1, i), t(:, j, i), d);
            
            disp([num2str(j), ' ', num2str(i), ' ', num2str(a(1, j-1, i)), ' ', ...
                    num2str(a(2, j-1, i))]);
        end
    end
end
