function xbtCompare(ctd, usb, mk9, navy, usbOff, mk9Off, navyOff)

% Function to compare XBT drops with a CTD

if nargin < 7
   navyOff = 0;
end

if nargin < 6
   mk9Off = 0;
end

if nargin < 5
   usbOff = 0;
end

if nargin < 4
   navy = [];
end

if nargin < 3
   mk9 = [];
end

% Read CTD file

path = 'c:/data/fr0204';
nc = netcdf([path, '/avg/', ctd, 'Avg.nc']);
Pctd = nc{'pressure'}(:);
[x, i] = max(Pctd);
Pctd = Pctd(1:i);
Tctd = nc{'temperature'}(1:i);
lat = nc{'latitude'}(1);
close(nc);
Dctd = sw_dpth(Pctd, lat);
%Dctd = Pctd;

% Read USB file

nc = netcdf([path, '/xbt/usb/', usb, '.nc']);
%r = nc{'rawTemperature'}(:);
%r = -13.2 + 1.000168 * r;
%Tusb = xbtTemp(r);
%Dusb = xbtDepth(r) - usbOff;
Dusb = nc{'depth'}(:) - usbOff;
Tusb = nc{'temperature'}(:);
close(nc);
figure(1);
plot(Tctd, Dctd);
set(gca, 'YDir', 'reverse');
title(['CTD:', ctd, ' USB:', usb]);
xlabel('Temperature (C)');
ylabel('Depth (m)');
hold on
plot(Tusb, Dusb, 'r');
hold off
axis([0 25 0 1000]);
legend('CTD', 'USB', 2);
figure(2);
Tint = interp1(Dctd, Tctd, Dusb);
plot(Tusb - Tint, Dusb);
set(gca, 'YDir', 'reverse');
title(['USB:', usb, ' - CTD:', ctd]);
xlabel('Temperature error (C)');
ylabel('Depth (m)');
axis([-2 2 0 1000]);
hold on
plot([-0.1 -0.1], [0 1000], 'g--');
plot([0.1 0.1], [0 1000], 'g--');
hold off

% Read MK9 file

if ~isempty(mk9)
   nc = netcdf([path, '/xbt/mk9/', mk9, '.nc']);
   Dmk9 = nc{'depth'}(:) - mk9Off;
   Tmk9 = nc{'temperature'}(:);
   close(nc);
   figure(3);
   plot(Tctd, Dctd);
   set(gca, 'YDir', 'reverse');
   title(['CTD:', ctd, ' Mk9:', mk9]);
   xlabel('Temperature (C)');
   ylabel('Depth (m)');
   hold on
   plot(Tmk9, Dmk9, 'r');
   hold off
   axis([0 25 0 1000]);
   legend('CTD', 'Mk9', 2);
   figure(4);
   Tint = interp1(Dctd, Tctd, Dmk9);
   plot(Tmk9 - Tint, Dmk9);
   set(gca, 'YDir', 'reverse');
   title(['Mk9:', mk9, ' - CTD:', ctd]);
   xlabel('Temperature error (C)');
   ylabel('Depth (m)');
   axis([-2 2 0 1000]);
   hold on
   plot([-0.1 -0.1], [0 1000], 'g--');
   plot([0.1 0.1], [0 1000], 'g--');
   hold off
end

% Read Navy file

if ~isempty(navy)
   d = load([path, '/xbt/navy/', navy, '.edf'], '-ascii');
   Dnav = d(:, 1) - navyOff;
   Tnav = d(:, 2);
   figure(5);
   plot(Tctd, Dctd);
   set(gca, 'YDir', 'reverse');
   title(['CTD:', ctd, ' Navy:', navy]);
   xlabel('Temperature (C)');
   ylabel('Depth (m)');
   hold on
   plot(Tnav, Dnav, 'r');
   hold off
   axis([0 25 0 1000]);
   legend('CTD', 'Navy', 2);
   figure(6);
   Tint = interp1(Dctd, Tctd, Dnav);
   plot(Tnav - Tint, Dnav);
   set(gca, 'YDir', 'reverse');
   title(['Navy:', navy, ' - CTD:', ctd]);
   xlabel('Temperature error (C)');
   ylabel('Depth (m)');
   axis([-2 2 0 1000]);
   hold on
   plot([-0.1 -0.1], [0 1000], 'g--');
   plot([0.1 0.1], [0 1000], 'g--');
   hold off
   
   figure(7);
   plot(Tusb, Dusb);
   set(gca, 'YDir', 'reverse');
   title(['USB:', usb, ' Navy:', navy]);
   xlabel('Temperature (C)');
   ylabel('Depth (m)');
   hold on
   plot(Tnav, Dnav, 'r');
   hold off
   axis([0 25 0 1000]);
   legend('USB', 'Navy', 2);
   figure(8);
   Tint = interp1(Dusb, Tusb, Dnav);
   plot(Tnav - Tint, Dnav);
   set(gca, 'YDir', 'reverse');
   title(['Navy:', navy, ' - USB:', usb]);
   xlabel('Temperature error (C)');
   ylabel('Depth (m)');
   axis([-2 2 0 1000]);
   hold on
   plot([-0.1 -0.1], [0 1000], 'g--');
   plot([0.1 0.1], [0 1000], 'g--');
   hold off   
end
