function [file, t, sd] = getTestTemp(path)

% Method to extract all test canister data for files in the given path.

t = [];
sd = [];
file = [];
d = dir([path, '/*.nc']);
for i = 1:length(d)
    nc = netcdf([path, '/', d(i).name]);
    if ~isempty(nc)
        test = nc.TestCanister(:);
        if strcmp(test, 'yes')
            testTemp = nc{'meanTestTemperature'}(:);
            testSD = nc{'testTemperatureSD'}(:);
            t1 = ones(1, 3) * NaN;
            sd1 = ones(1, 3) * NaN;
            for j = 1:length(testTemp)
                t1(j) = testTemp(j);
                sd1(j) = testSD(j);
            end
            
            t = [t; t1];
            sd = [sd; sd1];
            file = [file; d(i).name];
        end
    end
end
