function s = getStats(t, d, a)

s = struct('Toffset', NaN, 'ToffsetStnd', NaN, 'Doffset', NaN, ...
    'DoffsetStnd', NaN, 'Dstretch', NaN, 'DstretchStnd', NaN);

[nDepth, nXBT, nDrop] = size(t);
for j = 2:nXBT
    dOff = [];
    dStretch = [];
    tOff = [];
    for i = 1:nDrop
        k = find(~isnan(t(:, j, i)));
        if ~isempty(k)
            Tctd = t(:, 1, i);
            Txbt = t(:, j, i);
            a1 = a(1, j-1, i);
            a2 = a(2, j-1, i);
            d1 = a1 + d * a2;
            t1 = interp1(d1, Txbt, d);
            k = find(~isnan(Tctd) & ~isnan(t1));
            t1 = t1(k);
            t2 = Tctd(k);
            tOff = [tOff; mean(t1 - t2)];
            dOff = [dOff; a1];;
            dStretch = [dStretch, a2];
        end
    end
    
    s(j-1).Toffset = mean(tOff);
    s(j-1).ToffsetStnd = std(tOff);
    s(j-1).Doffset = mean(dOff);
    s(j-1).DoffsetStnd = std(dOff);
    s(j-1).Dstretch = mean(dStretch);
    s(j-1).DstretchStnd = std(dStretch);
end
